/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.dialog.comp.TimeParameterJPanel;
import DE.siemens.ad.logo.dialog.comp.TimeUnitListCellRenderer;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class TimeValueOrReferencePanel
extends IntegerOrReferencePanel
implements PropertyChangeListener {
    public static final String TIME_UNIT_CHANGE_EVENT_NAME = TimeParameterJPanel.TIME_UNIT_CHANGE_EVENT_NAME;
    private TimeParameterJPanel fTimeParamPanel;
    private JComboBox fReferenceTimeUnitCombo;
    private JPanel fReferencePanel;
    private Timer fTimer;

    public TimeValueOrReferencePanel() {
    }

    public TimeValueOrReferencePanel(Timer timer) {
        this.fTimer = timer;
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        this.fInputManager = new CardLayout(1, 1);
        this.fInputPanel = new JPanel(this.fInputManager);
        JPanel timeInputPanel = new JPanel(new GridBagLayout());
        this.fTimeParamPanel = new TimeParameterJPanel();
        this.fTimeParamPanel.addPropertyChangeListener(TimeParameterJPanel.TIME_UNIT_CHANGE_EVENT_NAME, this);
        this.fTimeParamPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        timeInputPanel.add((Component)this.fTimeParamPanel, gbc);
        this.fInputPanel.add((Component)timeInputPanel, "Value");
        this.fReferencePanel = new JPanel(new GridBagLayout());
        this.fInputPanel.add((Component)this.fReferencePanel, "Reference");
        this.fReferenceList = new JComboBox();
        BlockListCellRenderer renderer = new BlockListCellRenderer(true);
        renderer.setScale(0.5f);
        this.fReferenceList.setRenderer(renderer);
        this.fReferenceTimeUnitCombo = new JComboBox<TimeUnit>(this.getTimeUnitsForReference());
        this.fReferenceTimeUnitCombo.setRequestFocusEnabled(false);
        this.fReferenceTimeUnitCombo.setRenderer(new TimeUnitListCellRenderer(false, "lowValue"));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.fReferencePanel.add((Component)this.fReferenceList, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.fReferencePanel.add((Component)this.fReferenceTimeUnitCombo, gbc);
        this.fReferenceButton = new JToggleButton("Reference");
        this.fReferenceButton.addActionListener(new IntegerOrReferencePanel.ReferenceButtonListener());
        this.add(this.fInputPanel);
        this.add(this.fReferenceButton);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void addReferenceTimeUnitChangedListener(ItemListener l) {
        if (this.fReferenceTimeUnitCombo != null) {
            this.fReferenceTimeUnitCombo.addItemListener(l);
        }
    }

    protected TimeUnit[] getTimeUnitsForReference() {
        return new TimeUnit[]{new Hours(), new Minutes(), new HighResolutionSeconds()};
    }

    public void setLabels() {
        super.setLabels();
        String timerName = this.fTimer.getName();
        if (timerName == null || timerName.length() == 0) {
            timerName = "dialog.timeParameter.title";
        }
        this.setTitle(Language.getString(timerName, timerName));
    }

    public boolean checkChanged() {
        if (this.fValue.isReference() != this.fReferenceButton.isSelected()) {
            return true;
        }
        if (!(!this.fValue.isReference() || this.equalItems(this.fValue.getReference(), (ParameterItem)this.fReferenceList.getSelectedItem()) && this.fTimer.getParamTime().getUnitKey().equals(this.fReferenceTimeUnitCombo.getSelectedItem()))) {
            return true;
        }
        return this.fTimeParamPanel.checkChanged();
    }

    public boolean checkFieldContents() {
        if (this.fReferenceButton.isSelected()) {
            return true;
        }
        return this.fTimeParamPanel.checkFieldContents();
    }

    public void loadFieldContents() {
        this.fValue = this.fTimer.getParamTimeProperties();
        boolean reference = this.fValue.isReference();
        this.fTimeParamPanel.setTimer(this.fTimer);
        this.fTimeParamPanel.setTitle(null);
        if (reference) {
            this.selectItemInReferenceList(this.fValue);
            this.selectItemInTimeUnitList();
            this.fReferenceButton.setSelected(true);
        } else {
            this.fTimeParamPanel.loadFieldContents();
        }
        this.setReference(reference);
    }

    private void selectItemInTimeUnitList() {
        Reference refTimeUnit = (Reference)this.fTimer.getParamTime();
        String unitKey = refTimeUnit.getTimeUnit().getUnitKey();
        ComboBoxModel model = this.fReferenceTimeUnitCombo.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            if (!((TimeUnit)model.getElementAt(i)).getUnitKey().equals(unitKey)) continue;
            this.fReferenceTimeUnitCombo.setSelectedIndex(i);
        }
    }

    public void storeFieldContents() {
        if (this.fReferenceButton.isSelected()) {
            Reference newValue = new Reference();
            newValue.setTimeUnit((TimeUnit)this.fReferenceTimeUnitCombo.getSelectedItem());
            newValue.setReference((ParameterItem)this.fReferenceList.getSelectedItem());
            this.fTimer.setParamTime(newValue);
        } else {
            this.fTimeParamPanel.storeFieldContents();
        }
    }

    public void setReferenceVisability(boolean visable) {
        this.fReferenceButton.setVisible(visable);
    }

    protected void setReference(boolean referenceEnabled) {
        super.setReference(referenceEnabled);
    }

    protected void referenceButtonPressed(boolean pressed) {
        super.referenceButtonPressed(pressed);
        if (pressed) {
            this.firePropertyChange(TIME_UNIT_CHANGE_EVENT_NAME, null, this.fReferenceTimeUnitCombo.getSelectedItem());
        }
    }
}

